"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var TLTextShape_exports = {};
__export(TLTextShape_exports, {
  textShapeMigrations: () => textShapeMigrations,
  textShapeProps: () => textShapeProps,
  textShapeVersions: () => Versions
});
module.exports = __toCommonJS(TLTextShape_exports);
var import_validate = require("@tldraw/validate");
var import_TLShape = require("../records/TLShape");
var import_TLColorStyle = require("../styles/TLColorStyle");
var import_TLFontStyle = require("../styles/TLFontStyle");
var import_TLSizeStyle = require("../styles/TLSizeStyle");
var import_TLTextAlignStyle = require("../styles/TLTextAlignStyle");
const textShapeProps = {
  color: import_TLColorStyle.DefaultColorStyle,
  size: import_TLSizeStyle.DefaultSizeStyle,
  font: import_TLFontStyle.DefaultFontStyle,
  textAlign: import_TLTextAlignStyle.DefaultTextAlignStyle,
  w: import_validate.T.nonZeroNumber,
  text: import_validate.T.string,
  scale: import_validate.T.nonZeroNumber,
  autoSize: import_validate.T.boolean
};
const Versions = (0, import_TLShape.createShapePropsMigrationIds)("text", {
  RemoveJustify: 1,
  AddTextAlign: 2
});
const textShapeMigrations = (0, import_TLShape.createShapePropsMigrationSequence)({
  sequence: [
    {
      id: Versions.RemoveJustify,
      up: (props) => {
        if (props.align === "justify") {
          props.align = "start";
        }
      },
      down: "retired"
    },
    {
      id: Versions.AddTextAlign,
      up: (props) => {
        props.textAlign = props.align;
        delete props.align;
      },
      down: (props) => {
        props.align = props.textAlign;
        delete props.textAlign;
      }
    }
  ]
});
//# sourceMappingURL=TLTextShape.js.map
